/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util.connection;

import java.util.Optional;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.chisel.ctm.api.client.Facade;
import team.chisel.ctm.client.CTMClient;
import team.chisel.ctm.client.util.BitUtil;
import team.chisel.ctm.client.util.connection.ConnectionDirection;

public class ConnectionLogic {
    protected byte connectionMap;
    public Optional<Boolean> disableObscuredFaceCheck = Optional.empty();
    protected boolean ignoreStates;
    protected StateComparator stateComparator = StateComparator.DEFAULT;

    public boolean ignoreStates() {
        return this.ignoreStates;
    }

    public StateComparator getStateComparator() {
        return this.stateComparator;
    }

    public ConnectionLogic ignoreStates(boolean ignoreStates) {
        this.ignoreStates = ignoreStates;
        return this;
    }

    public ConnectionLogic setStateComparator(StateComparator stateComparator) {
        this.stateComparator = stateComparator;
        return this;
    }

    public void buildConnectionMap(@NotNull class_1920 world, @NotNull class_2338 pos, @NotNull class_2350 side) {
        this.connectionMap = 0;
        this.buildConnectionMapInner(world, pos, side);
    }

    protected void buildConnectionMapInner(@NotNull class_1920 world, @NotNull class_2338 pos, @NotNull class_2350 side) {
        for (ConnectionDirection direction : ConnectionDirection.VALUES) {
            if (!this.isConnected(world, pos, side, direction)) continue;
            this.setConnected(direction, true);
        }
    }

    protected void setConnected(ConnectionDirection direction, boolean connected) {
        this.connectionMap = connected ? BitUtil.setBit(this.connectionMap, direction.ordinal()) : BitUtil.clearBit(this.connectionMap, direction.ordinal());
    }

    protected boolean isConnected(class_1920 world, class_2338 pos, class_2350 side, ConnectionDirection direction) {
        return this.isConnected(world, pos, direction.applyOffset(pos, side), side);
    }

    protected boolean isConnected(class_1920 world, class_2338 pos, class_2350 side, class_2680 state, ConnectionDirection direction) {
        return this.isConnected(world, pos, direction.applyOffset(pos, side), side, state);
    }

    protected boolean isConnected(class_1920 world, class_2338 pos, class_2338 connection, class_2350 side) {
        class_2680 state = this.getConnectionState(world, pos, connection, side);
        return this.isConnected(world, pos, connection, side, state);
    }

    protected boolean isConnected(class_1920 world, class_2338 pos, class_2338 connection, class_2350 side, class_2680 state) {
        class_2680 connectionState = this.getConnectionState(world, connection, pos, side);
        boolean connected = this.compare(state, connectionState, side);
        if (!connected) {
            return false;
        }
        if (this.disableObscuredFaceCheck.orElse(CTMClient.getConfigManager().getConfig().connectInsideCTM).booleanValue()) {
            return true;
        }
        class_2680 obscuring = this.getConnectionState(world, connection.method_10093(side), connection, side);
        return !this.compare(connectionState, obscuring, side);
    }

    protected class_2680 getConnectionState(class_1920 world, class_2338 pos, class_2338 connection, @Nullable class_2350 side) {
        class_2680 state = world.method_8320(pos);
        if (state.method_26204() instanceof Facade) {
            class_2680 facadeState = ((Facade)state.method_26204()).getFacadeState(world, pos, connection, side);
            if (facadeState != null) {
                return facadeState;
            }
            CTMClient.LOGGER.error("Received null facade blockstate from {} at {}.", (Object)state.method_26204(), (Object)pos);
        }
        return state;
    }

    protected boolean compare(class_2680 from, class_2680 to, class_2350 side) {
        return this.stateComparator.connects(this, from, to, side);
    }

    public boolean connected(ConnectionDirection direction) {
        return BitUtil.getBit(this.connectionMap, direction.ordinal());
    }

    public boolean connectedAnd(ConnectionDirection ... directions) {
        for (ConnectionDirection direction : directions) {
            if (this.connected(direction)) continue;
            return false;
        }
        return true;
    }

    public boolean connectedOr(ConnectionDirection ... directions) {
        for (ConnectionDirection direction : directions) {
            if (!this.connected(direction)) continue;
            return true;
        }
        return false;
    }

    public boolean connectedNone(ConnectionDirection ... directions) {
        for (ConnectionDirection direction : directions) {
            if (!this.connected(direction)) continue;
            return false;
        }
        return true;
    }

    public boolean connectedOnly(ConnectionDirection ... directions) {
        byte map = 0;
        for (ConnectionDirection direction : directions) {
            map = BitUtil.setBit(map, direction.ordinal());
        }
        return map == this.connectionMap;
    }

    public boolean hasConnections() {
        return this.connectionMap != 0;
    }

    public int numConnections() {
        return Integer.bitCount(this.connectionMap);
    }

    public long serialize() {
        return Byte.toUnsignedLong(this.connectionMap);
    }

    public void deserialize(long data) {
        this.connectionMap = (byte)data;
    }

    public static interface StateComparator {
        public static final StateComparator DEFAULT = (logic, from, to, side) -> logic.ignoreStates() ? from.method_26204() == to.method_26204() : from == to;

        public boolean connects(ConnectionLogic var1, class_2680 var2, class_2680 var3, class_2350 var4);
    }
}

